//English version asaq constructs/dimensions
const constructs = [
            ['C01D01', ['Humanlike','Appearance'], 295, 4],
            ['C01D02', ['Humanlike','Behavior'], 325, 4], 
            ['C01D03', ['Natural','Appearance'], 305, 4], 
            ['C01D04', ['Natural','Behavior'],  315, 4],
            ['C01D05', ['Appearance','Suitability'],  215, 3],
            ['C02', ['Usability'], 225, 3],
            ['C03', ['Performance'], 265, 3],
            ['C04', ['Likeability'],  155, 2],
            ['C05', ['Sociability'], 335, 4], 
            ['C06D01', ['Personality', 'Presence'], 5, 1], 
            ['C07', ['User','Acceptance'], 185, 3],
            ['C08', ['Enjoyability'], 165, 2],
            ['C09', ['User\'s','Engagement'], 205, 3],
            ['C10', ['User\'s','Trust'], 275, 4], 
            ['C11', ['User-Agent','Alliance'], 285, 4],
            ['C12', ['Attentiveness'], 235, 3],
            ['C13', ['Coherence'],255, 3],
            ['C14', ['Intentionality'], 245, 3],
            ['C15', ['User\'s','Attitude'], 195, 3],
            ['C16', ['Social', 'Presence'], 345, 4], 
            ['C17', ['Interaction','Impact on', 'Self-Image'], 175, 2],
            ['C18D01', ['Emotional', 'Intelligence', 'Presence'], 355, 4], 
            ['C18D03', ['User', 'Emotion', 'Presence'], 15, 1],
            ['C19', ['User-Agent', 'Interplay'], 25, 1], 
        ]; 
        
//Up to 4 ASA's names, values, and asaq scores 
const ASAcolors = ["magenta", "blue", "red", "orange"];
var ASAnames = [];
var ASAvalues = [];
var ASAscores = [];

//the percentile scores of long asaq constructs/dimensions
const long_p0 = [-2.54,-1.59,-1.50,-1.88,0.24,-0.62,0.18,-0.71,-1.23,-1.31,-0.26,-0.35,0.67,-0.46,-0.26,0.25,0.20,-0.66,-0.63,-1.43,-0.68,-2.17,-0.62,-0.51];
const long_p10 = [-2.41,-1.28,-1.24,-1.14,0.49,0.65,0.53,-0.57,-0.64,-0.64,0.03,0.06,1.04,-0.30,-0.17,0.84,0.85,-0.11,-0.01,-1.12,-0.15,-1.84,-0.38,0.05];
const long_p20 = [-2.14,-0.55,-0.94,-1.06,0.79,0.81,0.94,0.08,-0.28,-0.54,0.52,0.63,1.43,-0.03,0.10,1.32,1.07,0.13,0.21,-0.97,-0.06,-1.48,0.06,0.17];
const long_p30 = [-1.96,-0.28,-0.84,-0.81,1.01,0.89,1.04,0.36,-0.14,-0.44,0.74,0.86,1.54,0.11,0.32,1.40,1.33,0.33,0.36,-0.46,0.21,-1.36,0.26,0.54];
const long_p40 = [-1.76,-0.14,-0.64,-0.61,1.21,1.19,1.11,0.61,0.04,-0.13,0.98,1.03,1.67,0.30,0.48,1.66,1.48,0.51,1.08,-0.27,0.36,-1.11,0.36,0.61];
const long_p50 = [-1.09,0.14,-0.35,-0.38,1.41,1.27,1.16,0.77,0.15,0.04,1.10,1.18,1.78,0.40,0.59,1.75,1.58,0.68,1.41,-0.18,0.63,-0.92,0.49,0.68];
const long_p60 = [-0.31,0.31,0.04,-0.36,1.53,1.39,1.28,0.87,0.45,0.29,1.35,1.30,1.93,0.51,0.65,1.80,1.65,0.82,1.56,-0.02,0.78,-0.69,0.81,0.86];
const long_p70 = [0.88,0.52,0.39,-0.30,1.74,1.71,1.50,1.21,0.73,0.74,1.44,1.53,2.04,0.79,0.77,1.91,1.76,1.16,1.71,0.05,0.88,-0.15,1.03,1.02];
const long_p80 = [1.14,0.65,0.62,0.16,1.81,1.77,1.62,1.44,0.93,1.04,1.58,1.86,2.12,1.04,0.84,2.04,1.89,1.42,1.90,0.23,0.93,0.26,1.51,1.14];
const long_p90 = [1.69,0.92,0.87,1.21,1.99,1.99,1.78,1.74,1.25,1.35,1.99,2.03,2.25,1.18,1.03,2.13,2.04,1.54,2.37,0.48,1.22,0.86,1.72,1.40];
const long_p100 = [2.09,1.70,1.85,2.21,2.14,2.21,2.07,2.31,1.51,1.47,2.13,2.32,2.33,1.30,1.14,2.22,2.11,1.80,2.50,0.75,1.45,1.15,1.88,1.68];

var long_percentiles = [long_p0, long_p10, long_p20, long_p30, long_p40, long_p50, long_p60, long_p70, long_p80, long_p90, long_p100];

const short_p0 = [-2.7, -1.77, -1.81, -1.64, 0.24, -0.34, 0.63, -0.75, -1.69, -0.56, -0.2, -0.5, 0.78, -0.59, -0.86, 0.17, -0.09, -0.62, -0.59, -1.69, -0.51, -2.41, -0.64, -1.03];
const short_p10 = [-2.62, -1.43, -1.24, -0.89, 0.44, 0.68, 0.69, -0.54, -1.22, -0.38, 0.35, -0.24, 1.1, -0.11, -0.79, 0.59, 0.91, -0.38, -0.06, -1.14, -0.06, -1.67, -0.45, -0.86];
const short_p20 = [-2.2, -0.51, -1.1, -0.82, 0.74, 1.03, 0.88, 0.03, -1.05, 0.03, 0.5, 0.03, 1.38, 0.18, -0.54, 0.95, 1.17, 0.53, 0.24, -0.95, 0.37, -1.28, -0.15, -0.65];
const short_p30 = [-2.14, -0.03, -0.97, -0.4, 0.9, 1.06, 1.17, 0.41, -0.71, 0.16, 0.72, 0.41, 1.51, 0.25, -0.28, 1.23, 1.31, 0.69, 0.49, -0.5, 0.51, -1.22, 0.05, -0.1];
const short_p40 = [-1.75, 0.12, -0.6, 0, 1.18, 1.28, 1.29, 0.58, -0.47, 0.28, 1, 0.66, 1.59, 0.37, -0.22, 1.49, 1.45, 0.97, 0.97, -0.19, 0.69, -0.9, 0.54, 0.17];
const short_p50 = [-1.17, 0.44, -0.46, 0.25, 1.49, 1.45, 1.51, 0.85, -0.38, 0.33, 1.31, 0.89, 1.74, 0.57, -0.08, 1.61, 1.57, 1.14, 1.38, -0.13, 0.9, -0.36, 0.65, 0.38];
const short_p60 = [-0.19, 0.65, -0.2, 0.45, 1.66, 1.65, 1.54, 1.3, -0.25, 0.73, 1.56, 1.06, 1.84, 0.68, 0, 1.68, 1.69, 1.24, 1.47, 0, 1.03, -0.06, 1, 0.62];
const short_p70 = [0.95, 0.77, 0.33, 0.53, 1.85, 1.83, 1.76, 1.47, 0.08, 0.86, 1.62, 1.41, 2.06, 0.84, 0.41, 1.75, 1.76, 1.53, 1.62, 0.05, 1.17, 0.23, 1.17, 0.81];
const short_p80 = [1.34, 0.97, 0.61, 0.89, 1.95, 2, 1.97, 1.72, 0.43, 1.31, 1.89, 1.69, 2.2, 1.17, 0.51, 1.82, 2, 1.69, 2.03, 0.5, 1.28, 0.53, 1.69, 1.22];
const short_p90 = [1.87, 1.37, 1, 1.74, 2.03, 2.22, 2.28, 2, 0.84, 1.42, 2.05, 1.86, 2.31, 1.49, 0.83, 1.97, 2.1, 1.83, 2.33, 0.65, 1.34, 1.14, 2.05, 1.31];
const short_p100 = [2.2, 1.97, 2.16, 2.57, 2.28, 2.26, 2.51, 2.62, 1.18, 1.56, 2.36, 2.27, 2.36, 1.56, 1.14, 2.24, 2.25, 2.3, 2.49, 1.03, 1.65, 1.51, 2.31, 1.38];

var short_percentiles = [short_p0, short_p10, short_p20, short_p30, short_p40, short_p50, short_p60, short_p70, short_p80, short_p90, short_p100];

//the percentile scores of asaq scores of the representative set for both the long and short asaq versions
const percentile_headers = ['5%', '10%', '20%', '25%', '30%', '40%', '50%', '60%', '70%', '75%', '80%', '90%', '95%']
const long_asaqscore_percentiles = [-0.72, 2.68, 9.36, 10.37, 12.54, 13.58, 14.32, 16.41, 17.82, 19.28, 20.45, 24.91, 27.69];
const short_asaqscore_percentiles = [-0.05, 6.21 , 9.81 , 11.57, 12.79, 14.07, 14.95, 17.88, 19.67, 20.85, 21.81, 25.86, 30.20];
const asaqRating = [-3,-2,-1,0,1,2,3];

//functions for displaying the asaq chart
function resetChart(){
	ASAnames = [];
	ASAvalues = [];
	ASAscores = [];
}
function getNumberASAs(){return (ASAnames.length);}
function writeErrMsg(s){document.getElementById("errMsg").innerHTML = s;}
function dynamic(radius, p){return (radius/10* p);}
function getXEndLine(midX, radius, angle, offset){return midX + Math.cos(Math.PI * angle / 180) * dynamic(radius,7+offset);}
function getYEndLine(midY, radius, angle, offset){return midY + Math.sin(Math.PI * angle / 180) * dynamic(radius,7+offset);}
function getXPoint(midX, radius, angle, p){return midX + Math.cos(Math.PI * angle / 180) * dynamic(radius, p);}
function getYPoint(midY, radius, angle, p){return midY + Math.sin(Math.PI * angle / 180) * dynamic(radius, p);}
function getXName(midX, radius, angle, offset){return midX + Math.cos(Math.PI * angle / 180) * dynamic(radius, 7 + offset);}
function getYName(midY, radius, angle, wordLen, offset){return midY - (dynamic(radius, 0.4) * (wordLen-1)/2) + Math.sin(Math.PI * angle / 180) * dynamic(radius, 7 + offset);}

function drawPieSlice(ctx, midX, midY, radius, len, startAngle, endAngle, direction, strokeStyle, fillStyle){
	ctx.strokeStyle = strokeStyle;
	ctx.fillStyle= fillStyle;
	ctx.beginPath();
	var startX = midX + Math.cos(Math.PI * startAngle / 180) * len;
	var startY = midY + Math.sin(Math.PI * startAngle / 180) * len;
	var endX = midX + Math.cos(Math.PI * endAngle / 180) * len;
	var endY = midY + Math.sin(Math.PI * endAngle / 180) * len;
	var sliceStartAngle = Math.PI * startAngle / 180;
	var sliceEndAngle = Math.PI * endAngle / 180;
	ctx.moveTo(midX, midY);
	ctx.arc(midX, midY, len, sliceStartAngle, sliceEndAngle, direction); 
	ctx.fill();
	ctx.moveTo(startX, startY);
	ctx.lineTo(midX, midY);
	ctx.lineTo(endX, endY);
	ctx.stroke();
	ctx.closePath();
}

function drawWeb(points, pointsLabels, distant, isPercentile){
	var canvas = document.getElementById("asaweb_canvas"); 
	var context = canvas.getContext( "2d" );
	var midX = canvas.width/2; 
	var midY = canvas.width/2; 
	var radius = canvas.width/2;
	context.clearRect(0, 0, canvas.width, canvas.height);
	
	//draw pieslices
	 drawPieSlice(context, midX, midY, radius, dynamic(radius, 9.4), 30, 150, true, "black", "white");
	 
	if (isPercentile === 1){
		//draw outer gray
		drawPieSlice(context, midX, midY, radius, dynamic(radius, points[points.length-1]), 30, 150, true, "rgba(173,173,173, 0.75)", 
					 "rgba(173,173,173, 0.75)");
					 
		drawPieSlice(context, midX, midY, radius, dynamic(radius, points[points.length-2]), 30, 150, true, "white", "white");


		//draw inner gray
		drawPieSlice(context, midX, midY, radius, dynamic(radius, points[1]), 30, 150, true, "rgba(173,173,173, 0.75)", 
		"rgba(173,173,173, 0.75)");
		
		//draw lines;
		context.strokeStyle="black";
		context.beginPath();
		context.moveTo(midX, midY);
		context.lineTo(getXEndLine(midX, radius, 30, 0.1), getYEndLine(midY, radius, 30, 0.1));
		context.stroke();
		context.moveTo(midX, midY);
		context.lineTo(getXEndLine(midX, radius, 150, 0.1), getYEndLine(midY, radius, 150, 0.1));
		context.stroke();
		context.closePath();
	}
	
	var names="";
	for( var i = 0; i < constructs.length; i++ ){
		var id = constructs[i][0];
		var name = constructs[i][1];
		var angle = constructs[i][2];
		var quadrant = constructs[i][3];
		
		//draw lines;
		context.strokeStyle="gray";
		context.beginPath();
		context.moveTo(midX, midY);
		context.lineTo(getXEndLine(midX, radius, angle, 0.01), getYEndLine(midY, radius, angle, 0.01));
		context.stroke();
		context.closePath();
		
		//draw dots
		for( var j = 0; j < points.length; j++ ){
			var point = points[j];
			if (j > 0 && j < pointLabels.length-1){
				context.beginPath();
				context.fillStyle="gray";
				var pX=getXPoint(midX, radius, angle, point);
				var pY=getYPoint(midY, radius, angle, point);
				context.moveTo(pX, pY);
				context.arc(pX, pY, 2, 0, Math.PI * 2, true);
				context.fill();
				context.closePath();
				
				var pointSize = canvas.width/70;
				context.fillStyle="brown";
				context.font= "bold " + pointSize +"px Verdana";
				context.textAlign = 'center';
				
				//draw labels
				if (pointLabels.length > 0){
					if (id ==="C03"){
						if (isPercentile === 1){
							if (j== 1) context.fillText(pointLabels[j].trim(), pX+ dynamic(radius,0.175), pY + dynamic(radius,0.1));
							else if (j == 11) context.fillText(pointLabels[j].trim(), pX+ dynamic(radius,0.35), pY+ dynamic(radius,0.1) );
							else if (j%2 != 0) context.fillText(pointLabels[j].trim(), pX+ dynamic(radius,0.275), pY + dynamic(radius,0.1));
						}
						else context.fillText(pointLabels[j].trim(), pX+ dynamic(radius,0.25), pY + dynamic(radius,0.075));
					}
				}
			}
		}
		//draw names
		for( var k = 0; k < name.length; k++ ){
			var nameSize = canvas.width/65;
			context.fillStyle="black";
			context.font= "bold " + nameSize+"px Verdana";
			if (id === "C03")  {
				context.textAlign = 'center';
				context.fillText(name[k], getXName(midX, radius, angle, 0.15) - (dynamic(radius,0.3)), 
				                 getYName(midY, radius, angle, name.length, 0.15) + (k * dynamic(radius,0.38))-dynamic(radius,0.3));
			}
			else {
				if (quadrant === 2 || quadrant == 3) context.textAlign = 'right';
				else context.textAlign = 'left';
				if (id === "C11") context.fillText(name[k], getXName(midX, radius, angle, 0.15) - dynamic(radius,0.4), getYName(midY, radius, angle, name.length, 0.15) - dynamic(radius,0.3) + (k*dynamic(radius,0.35)));
				else if (id === "C10") context.fillText(name[k], getXName(midX, radius, angle, 0.15) - dynamic(radius,0.3), getYName(midY, radius, angle, name.length, 0.15) - dynamic(radius,0.3) + (k*dynamic(radius,0.35)));
				else if (id === "C01D01") context.fillText(name[k], getXName(midX, radius, angle, 0.15), getYName(midY, radius, angle, name.length, 0.15) - dynamic(radius,0.3) + (k*dynamic(radius,0.35)));
				else context.fillText(name[k], getXName(midX, radius, angle, 0.15), getYName(midY, radius, angle, name.length, 0.15) + (k*dynamic(radius,0.35)));
			}
		}
	}
	//draw circle
	context.beginPath();
	context.fillStyle="white";
	context.moveTo(midX, midY);
	context.arc(midX, midY, dynamic(radius, points[0]), 0, Math.PI * 2, true);
	context.stroke();
	context.fill();
	context.closePath();
}

function getConstructIndex(cid){
	var found = 0;
	var i = 0;            
	while (found != 1 && i < constructs.length){
		
		if (constructs[i][0] === cid) found = 1;
		else i = i + 1;
	}
	return(i);
}

function drawValues(context, input, values, color, midX, midY, radius){
	
	//draw chart
		var cIdx = getConstructIndex(input[0]);
		var angle = constructs[cIdx][2];
		var point = values[cIdx];
		var pX = getXPoint(midX, radius, angle, point);
		var pY = getYPoint(midY, radius, angle, point);
		context.strokeStyle = color;
		context.fillStyle = color;
		context.lineWidth = 3;
		context.beginPath();
		context.moveTo(pX, pY);
		for( var i = 1; i < input.length; i++ ){
			cIdx = getConstructIndex(input[i]);
			angle = constructs[cIdx][2];
			point = values[cIdx];
			pX = getXPoint(midX, radius, angle, point);
			pY = getYPoint(midY, radius, angle, point);
			context.lineTo(pX, pY);
		}
		context.stroke();
		context.closePath();
}


function drawASAChart(values, title, asaqScore){

	if (values.length > 0 && values[0] != "" && values[0] != -999){
		ASAnames.push(title);
		ASAvalues.push(values);
		ASAscores.push(asaqScore);

		var canvas = document.getElementById("asaweb_canvas"); 
		var context = canvas.getContext( "2d" );
		var midX = canvas.width/2; 
		var midY = canvas.width/2; 
		var radius = canvas.width/2;
		
		for(var i = 0; i < ASAvalues.length; i++){
			var color = ASAcolors[i];
			
			var input =["C04", "C08","C17", "C07", "C15", "C09", "C01D05", "C02", "C12", "C14", "C13", "C03", "C10", "C11", "C01D01", "C01D03", "C01D04", "C01D02", "C05", "C16", "C18D01", "C06D01", "C18D03", "C19"];
		
			//draw values
			drawValues(context, input, ASAvalues[i], color, midX, midY, radius);
	
			//draw total values
			var nameSize = canvas.width/45;
			context.font= nameSize + "px Arial";
			context.textAlign = 'center';
			if (ASAscores.length == 1) 
				context.fillText(ASAscores[i], midX, midY);
			else 
				context.fillText(ASAscores[i], midX, midY + dynamic(radius, 0.2 + (i * 0.25) - ((ASAscores.length-i)*0.175)));
			
			if (ASAnames[i]!==""){
				//draw title
				context.font= canvas.width/30+"px Arial";
				context.fillStyle = ASAcolors[i];
				context.textAlign = 'center';
				context.fillText(ASAnames[i], midX + Math.cos(Math.PI * 90 / 180) * dynamic(radius, 3), midY + Math.sin(Math.PI * 90 / 180) * dynamic(radius, 2 + i));
			}
		}
		window.scrollTo(0, 200);
	}
}

function getValue(asaqversion, points, value, cid, isPercentile){
	if (isPercentile === 1) {
		if (asaqversion == "long") return getPercentileValue(long_percentiles, points, value, cid);
		else return getPercentileValue(short_percentiles, points, value, cid);
	}
	else {
		var found = 0;
		var i = 0;            
		
		while (found == 0 && i < asaqRating.length){
			if (asaqRating[i] == value) found = 1;
			else if (asaqRating[i] > value) found = 2;
			else i = i + 1;
		}
		
		
		if (found == 1){ //percentile[perc_i][cid] == value
			return points[i];
		}
		else if (found == 2){//percentile[perc_i][cid] > value
			if (i == 0) return points[0];
			else  //perc_i > 0 && perc_i < percentile.length
				return(getPointValue(asaqRating[i-1], asaqRating[i], points[i-1], points[i], value));
		}
		else { //perc_i > percentile.length
			return points[points.length-1];
		}
	}
}

function getASAQscore(asaqversion, values, isPercentile){
	total = 0;
	for( var i = 0; i < values.length; i++ ){
		total = total + values[i];
	}
	
	if (isPercentile === 1) return getASAQscorePercentile(asaqversion, total);
	else return Math.round(total);
}

function getPercentileValue(percentile, points, value, cid){
	var found = 0;
	var perc_i = 0;            
	
	while (found == 0 && perc_i < percentile.length){
		if (percentile[perc_i][cid] == value) found = 1;
		else if (percentile[perc_i][cid] > value) found = 2;
		else perc_i = perc_i + 1;
	}
	
	var a = 0;
	var b = 0;
	var c = 0;
	var d = 0;
	var x = value;
	var i = perc_i + 1
	
	if (found == 1){ //percentile[perc_i][cid] == value
		return points[i];
	}
	else if (found == 2){//percentile[perc_i][cid] > value
		if (perc_i == 0) {
			a = -3;
			b = percentile[perc_i][cid];
			c = points[0];
			d = points[1];
		}
		else { //perc_i > 0 && perc_i < percentile.length
			a = percentile[perc_i-1][cid];
			b = percentile[perc_i][cid];
			c = points[i-1];
			d = points[i];
		}
	}
	else { //perc_i > percentile.length
		a = percentile[percentile.length-1][cid];
		b = 3;
		c = points[points.length-2];
		d = points[points.length-1];
	}
			
	return(getPointValue(a, b, c, d, x));
	
}

function getPointValue(a, b, c, d, x){
	return ((Math.abs(x - a) * Math.abs(d - c)) / Math.abs(b - a)) + c;
}

function getASAQscorePercentile(asaqversion, asaqscore){
	var found = 0;
	var perc_i = 0;            
	var scores = [];
	if (asaqversion === 'long') scores = long_asaqscore_percentiles;
	else scores = short_asaqscore_percentiles;
	while (found == 0 && perc_i < scores.length){
		if (scores[perc_i] >= asaqscore) found = 1;
		else perc_i = perc_i + 1;
	}
	
	if (found === 1) return percentile_headers[perc_i];
	else return ">95%";
}
